<?php
/*
Plugin Name: Daily Hadith Widget
Plugin URI: https://wordpress.org/plugins/daily-hadith-widget
Description: Add daily hadith widget to your Wordpress
Version: 3.0.0
Author: nath4n
Author URI: https://profiles.wordpress.org/nath4n
License: GPL2
*/

add_action( 'wp_enqueue_scripts', function() {
	wp_enqueue_script( 'jquery' );
    wp_enqueue_style( 'bootstrap-css' , '//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css' );    
    wp_enqueue_script( 'bootstrap-js' , 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js' , array( 'jquery' ),'',true );
	wp_enqueue_style( 'simplesharingbuttons-css' , '//simplesharingbuttons.com/css/main.2.9.7.min.css' );
	wp_enqueue_style( 'fontawesome-css' , '//use.fontawesome.com/releases/v5.0.9/css/all.css' );
}, 10, 2 );

class wp_daily_hadith_widget extends WP_Widget {

	// constructor
	function wp_daily_hadith_widget() {
		$widget_ops = array('classname' => 'dailyhadith', 'description' => __('Add daily hadith widget (a different hadith daily from Bukhari, Muslim, Muwatta, Abu Dawood and Tirmidhi)', 'dailyhadith'));
		parent::WP_Widget(false, $name = __('Daily Hadith', 'wp_widget_plugin'), $widget_ops );
	}

	// widget form creation
	function form($instance) {	
		// Check values
		if( $instance) {
			 $title = esc_attr($instance['title']);
		} else {
			 $title = 'Daily Hadith';
		}
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title:', 'wp_widget_plugin'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" placeholder="Today's Hadith" />
		</p>		
		<?php
	}

	// widget update
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		// Fields
		$instance['title'] = strip_tags($new_instance['title']);		
		return $instance;
	}

	// widget display
	function widget($args, $instance) {
		extract( $args );
		// these are the widget options
		$title = apply_filters('widget_title', $instance['title']);
		echo $before_widget;
		// Check if title is set
		if ( $title ) {
			echo $before_title . $title . $after_title;
		}
		// Display the widget
		?>
		<style>
			.panel-body{
			  border-radius: 5px;
			  background-image: url(<?php echo PLUGINS_URL( 'images/islamic-bg.jpg' , __FILE__  ); ?>);
			  background-size: cover;
			  background-position: center;
			  background-repeat: no-repeat;
			  box-shadow: inset 0px 0px 20px #000;
			}
			
			.titleText {
				text-align:left;
				color: #333;
				text-shadow: 0px 6px 6px #ccc;
			}
			
			.linkStyle {
				color: #333;
			}
			
			ul {
			  justify-content: center;
			  display: flex;						
			  list-style-type:none;
			}
			
			li {
			  margin:0 0 0 10px;
			}			
		</style>
		<div class="panel panel-default panel widget-features">
			<div class="panel-body">
				<h4 class="titleText media-heading">Daily Hadith:&nbsp;<?php echo date('D') . '&nbsp;the&nbsp;'.date('jS F Y'); ?></h4>
				<div class="info">
					<script type="text/javascript" src="http://ahadith.co.uk/dh_v1.1.php"></script><noscript>Please enable JavaScript to see daily hadith</noscript>
				</div>
				<div style="margin:20px 0 0 0;">
					<ul class="share-buttons share-buttons-margin">
						<li class="unshifted"><a class="linkStyle" href="https://www.facebook.com/sharer/sharer.php?u=https://ahadith.co.uk/dailyhadith.php" target="_blank"><i class="fab fa-facebook-square fa-2x"></i></a></li>
						<li class="unshifted"><a class="linkStyle" href="https://twitter.com/intent/tweet?source=https://ahadith.co.uk/dailyhadith.php&amp;text=Hadith%20of%20the%20day: https://ahadith.co.uk/dailyhadith.php&amp;via=hadithoftheday" target="_blank" title="Tweet"><i class="fab fa-twitter-square fa-2x"></i></a></li>
						<li class="unshifted"><a class="linkStyle" href="https://plus.google.com/share?url=https://ahadith.co.uk/dailyhadith.php" target="_blank" title="Share on Google+"><i class="fab fa-google-plus-square fa-2x"></i></a></li>
						<li class="unshifted"><a class="linkStyle" href="http://www.tumblr.com/share?v=3&amp;u=https://ahadith.co.uk/dailyhadith.php&amp;t=Hadith%20of%20the%20day&amp;s=" target="_blank" title="Post to Tumblr"><i class="fab fa-tumblr-square fa-2x"></i></a></li>
					</ul>
				</div>
			 </div>
		</div>
		<?php
	}
}

// register widget
add_action('widgets_init', create_function('', 'return register_widget("wp_daily_hadith_widget");'));