<?php
/*
Plugin Name: Last post in category widget
Plugin URI: http://eogsoft.com/wp/widgets
Description: Add last post of a category [ Made for circuloislamico.com ]
Version: 0.01
Author: Emad Ghaly
Author URI: http://eogsoft.com/authors/emad
License: GPL2
*/
/* Start Adding Functions Below this Line */
// Creating the widget 
class last_of_category_widget extends WP_Widget {
 
// The construct part  
function __construct() {
	$widget_ops = array( 
		'classname' => 'last_of_category_widget',
		'description' => 'Shows last category post made for circuloislamico.com',
	);
	parent::__construct( 'last_of_category_widget', 'Last post in category Widget', $widget_ops );

}
  
// Creating widget front-end
public function widget( $args, $instance ) {
	echo $args['before_widget'];
	if ( ! empty( $instance['title'] ) ) {
		echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
	}
	echo esc_html__( 'Hello, World!', 'text_domain' );
	echo $args['after_widget'];
}
          
// Creating widget Backend 
public function form( $instance ) {
	$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'New title', 'text_domain' );
	?>
	<p>
	<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'text_domain' ); ?></label>
	<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
	</p>
	<?php 

}
      
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
	$instance = array();
	$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';

	return $instance;
}
 
// Class wpb_widget ends here
}
/* Stop Adding Functions Below this Line */
