// MSDropDown - jquery.dd.js

// author: Marghoob Suleman - http://www.marghoobsuleman.com/

// Date: 10 Nov, 2012 

// Version: 3.5.2

// Revision: 27

// web: www.marghoobsuleman.com

/*

// msDropDown is free jQuery Plugin: you can redistribute it and/or modify

// it under the terms of the either the MIT License or the Gnu General Public License (GPL) Version 2

*/ 

var msBeautify = msBeautify || {};

(function ($) {

	msBeautify = {

	version: {msDropdown:'3.5.2'},

	author: "Marghoob Suleman",

	counter: 20,

	debug: function (v) {

		if (v !== false) {

			$(".ddOutOfVision").css({height: 'auto', position: 'relative'});

		} else {

			$(".ddOutOfVision").css({height: '0px', position: 'absolute'});

		}

	},

	oldDiv: '',

	create: function (id, settings, type) {

		type = type || "dropdown";

		var data;

		switch (type.toLowerCase()) {

		case "dropdown":

		case "select":

			data = $(id).msDropdown(settings).data("dd");

			break;

		}

		return data;

	}

};



$.msDropDown = {}; //Legacy

$.msDropdown = {}; //camelCaps

$.extend(true, $.msDropDown, msBeautify);

$.extend(true, $.msDropdown, msBeautify);

// make compatibiliy with old and new jquery

if ($.fn.prop === undefined) {$.fn.prop = $.fn.attr;}

if ($.fn.on === undefined) {$.fn.on = $.fn.bind;$.fn.off = $.fn.unbind;}

if (typeof $.expr.createPseudo === 'function') {

	//jQuery 1.8  or greater

	$.expr[':'].Contains = $.expr.createPseudo(function (arg) {return function (elem) { return $(elem).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0; }; });

} else {

	//lower version

	$.expr[':'].Contains = function (a, i, m) {return $(a).text().toUpperCase().indexOf(m[3].toUpperCase()) >= 0; };

}

//dropdown class

function dd(element, settings) {

	var settings = $.extend(true,

		{byJson: {data: null, selectedIndex: 0, name: null, size: 0, multiple: false, width: 250},

		mainCSS: 'dd',

		height: 120, //not using currently

		visibleRows: 7,

		rowHeight: 0,

		showIcon: true,

		zIndex: 9999,

		useSprite: false,

		animStyle: 'slideDown',

		event:'click',

		openDirection: 'auto', //auto || alwaysUp || alwaysDown

		jsonTitle: true,

		style: '',

		disabledOpacity: 0.7,

		disabledOptionEvents: true,

		childWidth:0,

		enableCheckbox:false, //this needs to multiple or it will set element to multiple

		checkboxNameSuffix:'_mscheck',

		append:'',

		prepend:'',

		reverseMode:true, //it will update the msdropdown UI/value if you update the original dropdown - will be usefull if are using knockout.js or playing with original dropdown

		roundedCorner:true,

		enableAutoFilter:true,

		on: {create: null,open: null,close: null,add: null,remove: null,change: null,blur: null,click: null,dblclick: null,mousemove: null,mouseover: null,mouseout: null,focus: null,mousedown: null,mouseup: null}

		}, settings);								  

	var $this = this; //this class	 

	var holderId = {postElementHolder: '_msddHolder', postID: '_msdd', postTitleID: '_title',postTitleTextID: '_titleText', postChildID: '_child'};

	var css = {dd:settings.mainCSS, ddTitle: 'ddTitle', arrow: 'ddArrow arrowoff', ddChild: 'ddChild', ddTitleText: 'ddTitleText',disabled: 'disabled', enabled: 'enabled', ddOutOfVision: 'ddOutOfVision', borderTop: 'borderTop', noBorderTop: 'noBorderTop', selected: 'selected', divider: 'divider', optgroup: "optgroup", optgroupTitle: "optgroupTitle", description: "description", label: "ddlabel",hover: 'hover',disabledAll: 'disabledAll'};

	var css_i = {li: '_msddli_',borderRadiusTp: 'borderRadiusTp',ddChildMore: 'border shadow',fnone: "fnone"};

	var isList = false, isMultiple=false,isDisabled=false, cacheElement = {}, element, orginial = {}, isOpen=false;

	var DOWN_ARROW = 40, UP_ARROW = 38, LEFT_ARROW=37, RIGHT_ARROW=39, ESCAPE = 27, ENTER = 13, ALPHABETS_START = 47, SHIFT=16, CONTROL = 17, BACKSPACE=8, DELETE=46;

	var shiftHolded=false, controlHolded=false,lastTarget=null,forcedTrigger=false, oldSelected, isCreated = false;

	var doc = document, ua = window.navigator.userAgent, isIE = ua.match(/msie/i);

	settings.reverseMode = settings.reverseMode.toString();

	settings.roundedCorner = settings.roundedCorner.toString();

	var isArray = function(obj) {

		return (Object.prototype.toString.call(obj)=="[object Array]") ? true : false;

	};

	var msieversion = function()

   	{      

      var msie = ua.indexOf("MSIE");

      if ( msie > 0 ) {      // If Internet Explorer, return version number

         return parseInt (ua.substring (msie+5, ua.indexOf (".", msie)));

	  } else {                // If another browser, return 0

         return 0;

	  };

   	};

	var checkDataSetting = function() {

		settings.mainCSS = $("#"+element).data("maincss") || settings.mainCSS;

		settings.visibleRows = $("#"+element).data("visiblerows") || settings.visibleRows;

		if($("#"+element).data("showicon")==false) {settings.showIcon = $("#"+element).data("showicon");};

		settings.useSprite = $("#"+element).data("usesprite") || settings.useSprite;

		settings.animStyle = $("#"+element).data("animstyle") || settings.animStyle;

		settings.event = $("#"+element).data("event") || settings.event;

		settings.openDirection = $("#"+element).data("opendirection") || settings.openDirection;

		settings.jsonTitle = $("#"+element).data("jsontitle") || settings.jsonTitle;

		settings.disabledOpacity = $("#"+element).data("disabledopacity") || settings.disabledOpacity;

		settings.childWidth = $("#"+element).data("childwidth") || settings.childWidth;

		settings.enableCheckbox = $("#"+element).data("enablecheckbox") || settings.enableCheckbox;

		settings.checkboxNameSuffix = $("#"+element).data("checkboxnamesuffix") || settings.checkboxNameSuffix;

		settings.append = $("#"+element).data("append") || settings.append;

		settings.prepend = $("#"+element).data("prepend") || settings.prepend;

		settings.reverseMode = $("#"+element).data("reversemode") || settings.reverseMode;

		settings.roundedCorner = $("#"+element).data("roundedcorner") || settings.roundedCorner;

		settings.enableAutoFilter = $("#"+element).data("enableautofilter") || settings.enableAutoFilter;

		

		//make string

		settings.reverseMode = settings.reverseMode.toString();

		settings.roundedCorner = settings.roundedCorner.toString();

		settings.enableAutoFilter = settings.enableAutoFilter.toString();

	};	

	var getElement = function(ele) {

		if (cacheElement[ele] === undefined) {

			cacheElement[ele] = doc.getElementById(ele);

		}

		return cacheElement[ele];

	}; 	

	var getIndex = function(opt) {

		var childid = getPostID("postChildID"); 

		return $("#"+childid + " li."+css_i.li).index(opt);

	};

	var createByJson = function() {

		if (settings.byJson.data) {

				var validData = ["description","image","title"];

				try {

					if (!element.id) {

						element.id = "dropdown"+msBeautify.counter;

					};

					settings.byJson.data = eval(settings.byJson.data);

					//change element

					var id = "msdropdown"+(msBeautify.counter++);

					var obj = {};

					obj.id = id;

					obj.name = settings.byJson.name || element.id; //its name

					if (settings.byJson.size>0) {

						obj.size = settings.byJson.size;

					};

					obj.multiple = settings.byJson.multiple;

					var oSelect = createElement("select", obj);

					for(var i=0;i<settings.byJson.data.length;i++) {

						var current = settings.byJson.data[i];

						var opt = new Option(current.text, current.value);

						for(var p in current) { 

							if (p.toLowerCase() != 'text') { 

								var key = ($.inArray(p.toLowerCase(), validData)!=-1) ? "data-" : "";

								opt.setAttribute(key+p, current[p]);

							};

						};

						oSelect.options[i] = opt;

					};

					getElement(element.id).appendChild(oSelect);

					oSelect.selectedIndex = settings.byJson.selectedIndex;

					$(oSelect).css({width: settings.byJson.width+'px'});

					//now change element for access other things

					element = oSelect;

				} catch(e) {

					throw "There is an error in json data.";

				};

		};			

	};

	var init = function() {		

		 //set properties

		 createByJson();

		if (!element.id) {

			element.id = "msdrpdd"+(msBeautify.counter++);

		};						

		element = element.id;

		$this.element = element;

		checkDataSetting();		

		isDisabled = getElement(element).disabled;

		var useCheckbox = settings.enableCheckbox;

		if(useCheckbox.toString()==="true") {

			getElement(element).multiple = true;

			settings.enableCheckbox = true;

		};

		isList = (getElement(element).size>1 || getElement(element).multiple==true) ? true : false;

		//trace("isList "+isList);

		if (isList) {isMultiple = getElement(element).multiple;};			

		mergeAllProp();		

		//create layout

		createLayout();		

		//set ui prop

		updateProp("uiData", getDataAndUI());

		updateProp("selectedOptions", $("#"+element +" option:selected"));

		var childid = getPostID("postChildID");

		oldSelected = $("#" + childid + " li." + css.selected);

		

		if(settings.reverseMode==="true") {

			$("#"+element).on("change", function() {

				setValue(this.selectedIndex);

			});

		};

		//add refresh method

		getElement(element).refresh = function(e) {

			 $("#"+element).msDropdown().data("dd").refresh();

		};



	 };	

	 /********************************************************************************************/	

	var getPostID = function (id) {

		return element+holderId[id];

	};

	var getInternalStyle = function(ele) {		 

		 var s = (ele.style === undefined) ? "" : ele.style.cssText;

		 return s;

	};

	var parseOption = function(opt) {

		var imagePath = '', title ='', description='', value=-1, text='', className='', imagecss = '', index;

		if (opt !== undefined) {

			var attrTitle = opt.title || "";

			//data-title

			if (attrTitle!="") {

				var reg = /^\{.*\}$/;

				var isJson = reg.test(attrTitle);

				if (isJson && settings.jsonTitle) {

					var obj =  eval("["+attrTitle+"]");	

				};				 

				title = (isJson && settings.jsonTitle) ? obj[0].title : title;

				description = (isJson && settings.jsonTitle) ? obj[0].description : description;

				imagePath = (isJson && settings.jsonTitle) ? obj[0].image : attrTitle;

				imagecss = (isJson && settings.jsonTitle) ? obj[0].imagecss : imagecss;

				index = opt.index;

			};



			text = opt.text || '';

			value = opt.value || '';

			className = opt.className || "";

			//ignore title attribute if playing with data tags

			title = $(opt).prop("data-title") || $(opt).data("title") || (title || "");

			description = $(opt).prop("data-description") || $(opt).data("description") || (description || "");

			imagePath = $(opt).prop("data-image") || $(opt).data("image") || (imagePath || "");

			imagecss = $(opt).prop("data-imagecss") || $(opt).data("imagecss") || (imagecss || "");

			index = $(opt).index();

		};

		var o = {image: imagePath, title: title, description: description, value: value, text: text, className: className, imagecss:imagecss, index:index};

		return o;

	};	 

	var createElement = function(nm, attr, html) {

		var tag = doc.createElement(nm);

		if (attr) {

		 for(var i in attr) {

			 switch(i) {

				 case "style":

					tag.style.cssText = attr[i];

				 break;

				 default:

					tag[i]  = attr[i];

				 break;

			 };	

		 };

		};

		if (html) {

		 tag.innerHTML = html;

		};

		return tag;

	};

	 /********************************************************************************************/

	  /*********************** <layout> *************************************/

	var hideOriginal = function() {

		var hidid = getPostID("postElementHolder");

		if ($("#"+hidid).length==0) {			 

			var obj = {style: 'height: 0px;overflow: hidden;position: absolute;',className: css.ddOutOfVision};	

			obj.id = hidid;

			var oDiv = createElement("div", obj);	

			$("#"+element).after(oDiv);

			$("#"+element).appendTo($("#"+hidid));

		} else {

			$("#"+hidid).css({height: 0,overflow: 'hidden',position: 'absolute;'});

		};

		getElement(element).tabIndex = -1;

	};

	var createWrapper = function () {

		var brdRds = (settings.roundedCorner == "true") ? " borderRadius" : "";

		var obj = {

			className: css.dd + " ddcommon"+brdRds

		};

		var intcss = getInternalStyle(getElement(element));

		var w = $("#" + element).outerWidth();

		obj.style = "width: " + w + "px;";

		if (intcss.length > 0) {

			obj.style = obj.style + "" + intcss;

		};

		obj.id = getPostID("postID");

		obj.tabIndex = getElement(element).tabIndex;

		var oDiv = createElement("div", obj);

		return oDiv;

	};

	var createTitle = function () {

		var selectedOption;

		if(getElement(element).selectedIndex>=0) {

			selectedOption = getElement(element).options[getElement(element).selectedIndex];

		} else {

			selectedOption = {value:'', text:''};

		}

		var spriteClass = "", selectedClass = "";

		//check sprite

		var useSprite = $("#"+element).data("usesprite");

		if(useSprite) { settings.useSprite = useSprite; };

		if (settings.useSprite != false) {

			spriteClass = " " + settings.useSprite;

			selectedClass = " " + selectedOption.className;

		};

		var brdRdsTp = (settings.roundedCorner == "true") ? " "+css_i.borderRadiusTp : "" ;

		var oTitle = createElement("div", {className: css.ddTitle + spriteClass + brdRdsTp});

		//divider

		var oDivider = createElement("span", {className: css.divider});

		//arrow

		var oArrow = createElement("span", {className: css.arrow});

		//title Text

		var titleid = getPostID("postTitleID");

		var oTitleText = createElement("span", {className: css.ddTitleText + selectedClass, id: titleid});

	

		var parsed = parseOption(selectedOption);

		var arrowPath = parsed.image;

		var sText = parsed.text || "";		

		if (arrowPath != "" && settings.showIcon) {

			var oIcon = createElement("img");

			oIcon.src = arrowPath;

			if(parsed.imagecss!="") {

				oIcon.className = parsed.imagecss+" ";

			};

		};

		var oTitleText_in = createElement("span", {className: css.label}, sText);

		oTitle.appendChild(oDivider);

		oTitle.appendChild(oArrow);

		if (oIcon) {

			oTitleText.appendChild(oIcon);

		};

		oTitleText.appendChild(oTitleText_in);

		oTitle.appendChild(oTitleText);

		var oDescription = createElement("span", {className: css.description}, parsed.description);

		oTitleText.appendChild(oDescription);

		return oTitle;

	};

	var createFilterBox = function () {

		var tid = getPostID("postTitleTextID");

		var brdRds = (settings.roundedCorner == "true") ? "borderRadius" : "";

		var sText = createElement("input", {id: tid, type: 'text', value: '', autocomplete: 'off', className: 'text shadow '+brdRds, style: 'display: none'});

		return sText;

	};

	var createChild = function (opt) {

		var obj = {};

		var intcss = getInternalStyle(opt);

		if (intcss.length > 0) {obj.style = intcss; };

		var css2 = (opt.disabled) ? css.disabled : css.enabled;

		css2 = (opt.selected) ? (css2 + " " + css.selected) : css2;

		css2 = css2 + " " + css_i.li;

		obj.className = css2;

		if (settings.useSprite != false) {

			obj.className = css2 + " " + opt.className;

		};

		var li = createElement("li", obj);

		var parsed = parseOption(opt);

		if (parsed.title != "") {

			li.title = parsed.title;

		};

		var arrowPath = parsed.image;

		if (arrowPath != "" && settings.showIcon) {

			var oIcon = createElement("img");

			oIcon.src = arrowPath;

			if(parsed.imagecss!="") {

				oIcon.className = parsed.imagecss+" ";

			};

		};

		if (parsed.description != "") {

			var oDescription = createElement("span", {

				className: css.description

			}, parsed.description);

		};

		var sText = opt.text || "";

		var oTitleText = createElement("span", {

			className: css.label

		}, sText);

		//checkbox

		if(settings.enableCheckbox===true) {

			var chkbox = createElement("input", {

			type: 'checkbox', name:element+settings.checkboxNameSuffix+'[]', value:opt.value||"", className:"checkbox"}); //this can be used for future

			li.appendChild(chkbox);

			if(settings.enableCheckbox===true) {

				chkbox.checked = (opt.selected) ? true : false;

			};

		};

		if (oIcon) {

			li.appendChild(oIcon);

		};

		li.appendChild(oTitleText);

		if (oDescription) {

			li.appendChild(oDescription);

		} else {

			if (oIcon) {

				oIcon.className = oIcon.className+css_i.fnone;

			};

		};

		var oClear = createElement("div", {className: 'clear'});

		li.appendChild(oClear);

		return li;

	};

	var createChildren = function () {

		var childid = getPostID("postChildID");

		var obj = {className: css.ddChild + " ddchild_ " + css_i.ddChildMore, id: childid};

		if (isList == false) {

			obj.style = "z-index: " + settings.zIndex;

		} else {

			obj.style = "z-index:1";

		};

		var childWidth = $("#"+element).data("childwidth") || settings.childWidth;

		if(childWidth) {

			obj.style =  (obj.style || "") + ";width:"+childWidth;

		};		

		var oDiv = createElement("div", obj);

		var ul = createElement("ul");

		if (settings.useSprite != false) {

			ul.className = settings.useSprite;

		};

		var allOptions = getElement(element).children;

		for (var i = 0; i < allOptions.length; i++) {

			var current = allOptions[i];

			var li;

			if (current.nodeName.toLowerCase() == "optgroup") {

				//create ul

				li = createElement("li", {className: css.optgroup});

				var span = createElement("span", {className: css.optgroupTitle}, current.label);

				li.appendChild(span);

				var optChildren = current.children;

				var optul = createElement("ul");

				for (var j = 0; j < optChildren.length; j++) {

					var opt_li = createChild(optChildren[j]);

					optul.appendChild(opt_li);

				};

				li.appendChild(optul);

			} else {

				li = createChild(current);

			};

			ul.appendChild(li);

		};

		oDiv.appendChild(ul);		

		return oDiv;

	};

	var childHeight = function (val) {

		var childid = getPostID("postChildID");

		if (val) {

			if (val == -1) { //auto

				$("#"+childid).css({height: "auto", overflow: "auto"});

			} else {				

				$("#"+childid).css("height", val+"px");

			};

			return false;

		};

		//else return height

		var iHeight;

		var totalOptions = getElement(element).options.length;

		if (totalOptions > settings.visibleRows || settings.visibleRows) {

			var firstLI = $("#" + childid + " li:first");

			var margin = parseInt(firstLI.css("padding-bottom")) + parseInt(firstLI.css("padding-top"));

			if(settings.rowHeight===0) {

				$("#" + childid).css({visibility:'hidden',display:'block'}); //hack for first child

				settings.rowHeight = Math.ceil(firstLI.height());

				$("#" + childid).css({visibility:'visible'});

				if(!isList || settings.enableCheckbox===true) {

					$("#" + childid).css({display:'none'});

				};

			};

			iHeight = ((settings.rowHeight + margin) * Math.min(settings.visibleRows,totalOptions)) + 3;

		} else if (isList) {

			iHeight = $("#" + element).height(); //get height from original element

		};		

		return iHeight;

	};

	var applyChildEvents = function () {

		var childid = getPostID("postChildID");

		$("#" + childid).on("click", function (e) {

			if (isDisabled === true) return false;

			//prevent body click

			e.preventDefault();

			e.stopPropagation();

			if (isList) {

				bind_on_events();

			};

		});

		$("#" + childid + " li." + css.enabled).on("click", function (e) {

			if(e.target.nodeName.toLowerCase() !== "input") {

				close(this);

			};

		});

		$("#" + childid + " li." + css.enabled).on("mousedown", function (e) {

			if (isDisabled === true) return false;

			oldSelected = $("#" + childid + " li." + css.selected);

			lastTarget = this;

			e.preventDefault();

			e.stopPropagation();

			//select current input

			if(settings.enableCheckbox===true) {

				if(e.target.nodeName.toLowerCase() === "input") {

					controlHolded = true;

				};	

			};

			if (isList === true) {

				if (isMultiple) {					

					if (shiftHolded === true) {

						$(this).addClass(css.selected);

						var selected = $("#" + childid + " li." + css.selected);

						var lastIndex = getIndex(this);

						if (selected.length > 1) {

							var items = $("#" + childid + " li." + css_i.li);

							var ind1 = getIndex(selected[0]);

							var ind2 = getIndex(selected[1]);

							if (lastIndex > ind2) {

								ind1 = (lastIndex);

								ind2 = ind2 + 1;

							};

							for (var i = Math.min(ind1, ind2); i <= Math.max(ind1, ind2); i++) {

								var current = items[i];

								if ($(current).hasClass(css.enabled)) {

									$(current).addClass(css.selected);

								};

							};

						};

					} else if (controlHolded === true) {

						$(this).toggleClass(css.selected); //toggle

						if(settings.enableCheckbox===true) {

							var checkbox = this.childNodes[0];

							checkbox.checked = !checkbox.checked; //toggle

						};

					} else {

						$("#" + childid + " li." + css.selected).removeClass(css.selected);

						$("#" + childid + " input:checkbox").prop("checked", false);

						$(this).addClass(css.selected);

						if(settings.enableCheckbox===true) {

							this.childNodes[0].checked = true;

						};

					};					

				} else {

					$("#" + childid + " li." + css.selected).removeClass(css.selected);

					$(this).addClass(css.selected);

				};

				//fire event on mouseup

			} else {

				$("#" + childid + " li." + css.selected).removeClass(css.selected);

				$(this).addClass(css.selected);

			};		

		});

		$("#" + childid + " li." + css.enabled).on("mouseenter", function (e) {

			if (isDisabled === true) return false;

			e.preventDefault();

			e.stopPropagation();

			if (lastTarget != null) {

				if (isMultiple) {

					$(this).addClass(css.selected);

					if(settings.enableCheckbox===true) {

						this.childNodes[0].checked = true;

					};

				};

			};

		});

	

		$("#" + childid + " li." + css.enabled).on("mouseover", function (e) {

			if (isDisabled === true) return false;

			$(this).addClass(css.hover);

		});

		$("#" + childid + " li." + css.enabled).on("mouseout", function (e) {

			if (isDisabled === true) return false;

			$("#" + childid + " li." + css.hover).removeClass(css.hover);

		});

	

		$("#" + childid + " li." + css.enabled).on("mouseup", function (e) {

			if (isDisabled === true) return false;

			e.preventDefault();

			e.stopPropagation();

			if(settings.enableCheckbox===true) {

				controlHolded = false;

			};

			var selected = $("#" + childid + " li." + css.selected).length;			

			forcedTrigger = (oldSelected.length != selected || selected == 0) ? true : false;	

			fireAfterItemClicked();

			unbind_on_events(); //remove old one

			bind_on_events();

			lastTarget = null;

		});

	

		/* options events */

		if (settings.disabledOptionEvents == false) {

			$("#" + childid + " li." + css_i.li).on("click", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "click");

			});

			$("#" + childid + " li." + css_i.li).on("mouseenter", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "mouseenter");

			});

			$("#" + childid + " li." + css_i.li).on("mouseover", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "mouseover");

			});

			$("#" + childid + " li." + css_i.li).on("mouseout", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "mouseout");

			});

			$("#" + childid + " li." + css_i.li).on("mousedown", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "mousedown");

			});

			$("#" + childid + " li." + css_i.li).on("mouseup", function (e) {

				if (isDisabled === true) return false;

				fireOptionEventIfExist(this, "mouseup");

			});

		};

	};

	var removeChildEvents = function () {

		var childid = getPostID("postChildID");

		$("#" + childid).off("click");

		$("#" + childid + " li." + css.enabled).off("mouseenter");

		$("#" + childid + " li." + css.enabled).off("click");

		$("#" + childid + " li." + css.enabled).off("mouseover");

		$("#" + childid + " li." + css.enabled).off("mouseout");

		$("#" + childid + " li." + css.enabled).off("mousedown");

		$("#" + childid + " li." + css.enabled).off("mouseup");

	};

	var triggerBypassingHandler = function (id, evt_n, handler) {

		$("#" + id).off(evt_n, handler);

		$("#" + id).trigger(evt_n);

		$("#" + id).on(evt_n, handler);

	};

	var applyEvents = function () {

		var id = getPostID("postID");

		var tid = getPostID("postTitleTextID");

		var childid = getPostID("postChildID");		

		$("#" + id).on(settings.event, function (e) {			

			if (isDisabled === true) return false;

			fireEventIfExist(settings.event);

			//prevent body click

			e.preventDefault();

			e.stopPropagation();

			open(e);

		});

		$("#" + id).on("keydown", function (e) {

			var k = e.which;

			if (!isOpen && (k == ENTER || k == UP_ARROW || k == DOWN_ARROW ||

				k == LEFT_ARROW || k == RIGHT_ARROW ||

				(k >= ALPHABETS_START && !isList))) {

				open(e);

				if (k >= ALPHABETS_START) {

					showFilterBox();

				} else {

					e.preventDefault();

					e.stopImmediatePropagation();

				};

			};

		});

		$("#" + id).on("focus", wrapperFocusHandler);

		$("#" + id).on("blur", wrapperBlurHandler);

		$("#" + tid).on("blur", function (e) {

			//return focus to the wrapper without triggering the handler

			triggerBypassingHandler(id, "focus", wrapperFocusHandler);

		});

		applyChildEvents();		

		$("#" + id).on("dblclick", on_dblclick);

		$("#" + id).on("mousemove", on_mousemove);

		$("#" + id).on("mouseenter", on_mouseover);

		$("#" + id).on("mouseleave", on_mouseout);

		$("#" + id).on("mousedown", on_mousedown);

		$("#" + id).on("mouseup", on_mouseup);

	};

	var wrapperFocusHandler = function (e) {

		fireEventIfExist("focus");

	};

	var wrapperBlurHandler = function (e) {

		fireEventIfExist("blur");

	};

	//after create

	var fixedForList = function () {

		var id = getPostID("postID");

		var childid = getPostID("postChildID");		

		if (isList === true && settings.enableCheckbox===false) {

			$("#" + id + " ." + css.ddTitle).hide();

			$("#" + childid).css({display: 'block', position: 'relative'});	

			//open();

		} else {

			if(settings.enableCheckbox===false) {

				isMultiple = false; //set multiple off if this is not a list

			};

			$("#" + id + " ." + css.ddTitle).show();

			$("#" + childid).css({display: 'none', position: 'absolute'});

			//set value

			var first = $("#" + childid + " li." + css.selected)[0];

			$("#" + childid + " li." + css.selected).removeClass(css.selected);

			var index = getIndex($(first).addClass(css.selected));

			setValue(index);

		};

		childHeight(childHeight()); //get and set height 

	};

	var fixedForDisabled = function () {

		var id = getPostID("postID");

		var opc = (isDisabled == true) ? settings.disabledOpacity : 1;

		if (isDisabled === true) {

			$("#" + id).addClass(css.disabledAll);

		} else {

			$("#" + id).removeClass(css.disabledAll);

		};

	};

	var fixedSomeUI = function () {

		//auto filter

		var tid = getPostID("postTitleTextID");

		if(settings.enableAutoFilter=="true") {

			$("#" + tid).on("keyup", applyFilters);

		};

		//if is list

		fixedForList();

		fixedForDisabled();

	};

	var createLayout = function () {		

		var oDiv = createWrapper();

		var oTitle = createTitle();

		oDiv.appendChild(oTitle);

		//auto filter box

		var oFilterBox = createFilterBox();

		oDiv.appendChild(oFilterBox);

	

		var oChildren = createChildren();

		oDiv.appendChild(oChildren);

		$("#" + element).after(oDiv);

		hideOriginal(); //hideOriginal

		fixedSomeUI();

		applyEvents();

		

		var childid = getPostID("postChildID");

		//append

		if(settings.append!='') {

			$("#" + childid).append(settings.append);

		};

		//prepend

		if(settings.prepend!='') {

			$("#" + childid).prepend(settings.prepend);

		};		

		if (typeof settings.on.create == "function") {

			settings.on.create.apply($this, arguments);

		};

	};

	var selectUI_LI = function(indexes) {

		var childid = getPostID("postChildID");

		$("#" + childid + " li." + css_i.li).removeClass(css.selected);

		if(settings.enableCheckbox===true) {

			$("#" + childid + " li." + css_i.li + " input.checkbox").prop("checked", false);

		};

		if(isArray(indexes)===true) {

			for(var i=0;i<indexes.length;i++) {

				updateNow(indexes[i]);

			};

		} else {

			updateNow(indexes);

		};

		function updateNow(index) {

			$($("#" + childid + " li." + css_i.li)[index]).addClass(css.selected);

			if(settings.enableCheckbox===true) {

				$($("#" + childid + " li." + css_i.li)[index]).find("input.checkbox").prop("checked", "checked");

			};

			

		};

	};

	var selectMutipleOptions = function (bySelected, useIndexes) {

		var childid = getPostID("postChildID");

		var selected = bySelected || $("#" + childid + " li." + css.selected); //bySelected or by argument

		for (var i = 0; i < selected.length; i++) {

			var ind = (useIndexes===true) ? selected[i]  : getIndex(selected[i]);

			getElement(element).options[ind].selected = "selected";

		};

		setValue(selected);

	};

	var fireAfterItemClicked = function () {

		//console.log("fireAfterItemClicked")

		var childid = getPostID("postChildID");

		var selected = $("#" + childid + " li." + css.selected);		

		if (isMultiple && (shiftHolded || controlHolded) || forcedTrigger) {

			getElement(element).selectedIndex = -1; //reset old

		};

		var index;

		if (selected.length == 0) {

			index = -1;

		} else if (selected.length > 1) {

			//selected multiple

			selectMutipleOptions(selected);

		} else {

			//if one selected

			index = getIndex($("#" + childid + " li." + css.selected));

		};		

		if ((getElement(element).selectedIndex != index || forcedTrigger) && selected.length<=1) {			

			forcedTrigger = false;			

			var evt = has_handler("change");

			getElement(element).selectedIndex = index;	

			setValue(index);

			//local

			if (typeof settings.on.change == "function") {

				var d = getDataAndUI();

				settings.on.change(d.data, d.ui);

			};			

			$("#" + element).trigger("change");			

		};

	};

	var setValue = function (index, byvalue) {

		if (index !== undefined) {

			var selectedIndex, value, selectedText;

			if (index == -1) {

				selectedIndex = -1;

				value = "";

				selectedText = "";

				updateTitleUI(-1);

			} else {

				//by index or byvalue

				if (typeof index != "object") {

					var opt = getElement(element).options[index];

					getElement(element).selectedIndex = index;

					selectedIndex = index;

					value = parseOption(opt);

					selectedText = (index >= 0) ? getElement(element).options[index].text : "";

					updateTitleUI(undefined, value);

					value = value.value; //for bottom

				} else {

					//this is multiple or by option

					selectedIndex = (byvalue && byvalue.index) || getElement(element).selectedIndex;

					value = (byvalue && byvalue.value) || getElement(element).value;

					selectedText = (byvalue && byvalue.text) || getElement(element).options[getElement(element).selectedIndex].text || "";

					updateTitleUI(selectedIndex);

					//check if this is multiple checkbox					

				};

			};			

			updateProp("selectedIndex", selectedIndex);

			updateProp("value", value);

			updateProp("selectedText", selectedText);

			updateProp("children", getElement(element).children);

			updateProp("uiData", getDataAndUI());

			updateProp("selectedOptions", $("#" + element + " option:selected"));

		};

	};

	var has_handler = function (name) {

		//True if a handler has been added in the html.

		var evt = {byElement: false, byJQuery: false, hasEvent: false};

		var obj = $("#" + element);

		//console.log(name)

		try {

			//console.log(obj.prop("on" + name) + " "+name);

			if (obj.prop("on" + name) !== null) {

				evt.hasEvent = true;

				evt.byElement = true;

			};

		} catch(e) {

			//console.log(e.message);

		}

		// True if a handler has been added using jQuery.

		var evs;

		if (typeof $._data == "function") { //1.8

			evs = $._data(obj[0], "events");

		} else {

			evs = obj.data("events");

		};

		if (evs && evs[name]) {

			evt.hasEvent = true;

			evt.byJQuery = true;

		};

		return evt;

	};

	var bind_on_events = function () {

		unbind_on_events();

		$("body").on("click", close);

		//bind more events		 

		$(document).on("keydown", on_keydown);

		$(document).on("keyup", on_keyup);

		//focus will work on this	 		 

	};

	var unbind_on_events = function () {

		$("body").off("click", close);

		//bind more events

		$(document).off("keydown", on_keydown);

		$(document).off("keyup", on_keyup);

	};

	var applyFilters = function (e) {

		if(e.keyCode < ALPHABETS_START && e.keyCode!=BACKSPACE && e.keyCode!=DELETE) {

			return false;

		};

		var childid = getPostID("postChildID");

		var tid = getPostID("postTitleTextID");

		var sText = getElement(tid).value;

		if (sText.length == 0) {

			$("#" + childid + " li:hidden").show(); //show if hidden

			childHeight(childHeight());

		} else {

			$("#" + childid + " li").hide();

			var items = $("#" + childid + " li:Contains('" + sText + "')").show();

			if ($("#" + childid + " li:visible").length <= settings.visibleRows) {

				childHeight(-1); //set autoheight

			};

			if (items.length > 0 && !isList || !isMultiple) {

				$("#" + childid + " ." + css.selected).removeClass(css.selected);

				$(items[0]).addClass(css.selected);

			};	

		};		

		if (!isList) {

			adjustOpen();

		};

	};

	var showFilterBox = function () {

		if(settings.enableAutoFilter=="true") {

			var id = getPostID("postID");

			var tid = getPostID("postTitleTextID");

			if ($("#" + tid + ":hidden").length > 0 && controlHolded == false) {

				$("#" + tid + ":hidden").show().val("");

				//blur the wrapper without triggering the handler

				triggerBypassingHandler(id, "blur", wrapperBlurHandler);

				getElement(tid).focus();

			};

		};

	};

	var hideFilterBox = function () {

		var tid = getPostID("postTitleTextID");

		if ($("#" + tid + ":visible").length > 0) {

			$("#" + tid + ":visible").hide();

			getElement(tid).blur();

		};

	};

	var on_keydown = function (evt) {

		var tid = getPostID("postTitleTextID");

		var childid = getPostID("postChildID");

		switch (evt.keyCode) {

			case DOWN_ARROW:

			case RIGHT_ARROW:

				evt.preventDefault();

				evt.stopPropagation();

				//hideFilterBox();

				next();

				break;

			case UP_ARROW:

			case LEFT_ARROW:

				evt.preventDefault();

				evt.stopPropagation();

				//hideFilterBox();

				previous();

				break;

			case ESCAPE:

			case ENTER:

				evt.preventDefault();

				evt.stopPropagation();

				close();

				var selected = $("#" + childid + " li." + css.selected).length;	

				forcedTrigger = (oldSelected.length != selected || selected == 0) ? true : false;				

				fireAfterItemClicked();

				unbind_on_events(); //remove old one				

				lastTarget = null;			

				break;

			case SHIFT:

				shiftHolded = true;

				break;

			case CONTROL:

				controlHolded = true;

				break;

			default:

				if (evt.keyCode >= ALPHABETS_START && isList === false) {

					showFilterBox();

				};

				break;

		};

		if (isDisabled === true) return false;

		fireEventIfExist("keydown");

	};

	var on_keyup = function (evt) {

		switch (evt.keyCode) {

			case SHIFT:

				shiftHolded = false;

				break;

			case CONTROL:

				controlHolded = false;

				break;

		};

		if (isDisabled === true) return false;

		fireEventIfExist("keyup");

	};

	var on_dblclick = function (evt) {

		if (isDisabled === true) return false;

		fireEventIfExist("dblclick");

	};

	var on_mousemove = function (evt) {

		if (isDisabled === true) return false;

		fireEventIfExist("mousemove");

	};

	

	var on_mouseover = function (evt) {

		if (isDisabled === true) return false;

		evt.preventDefault();

		fireEventIfExist("mouseover");

	};

	var on_mouseout = function (evt) {

		if (isDisabled === true) return false;

		evt.preventDefault();

		fireEventIfExist("mouseout");

	};

	var on_mousedown = function (evt) {

		if (isDisabled === true) return false;

		fireEventIfExist("mousedown");

	};

	var on_mouseup = function (evt) {

		if (isDisabled === true) return false;

		fireEventIfExist("mouseup");

	};

	var option_has_handler = function (opt, name) {

		//True if a handler has been added in the html.

		var evt = {byElement: false, byJQuery: false, hasEvent: false};

		if ($(opt).prop("on" + name) != undefined) {

			evt.hasEvent = true;

			evt.byElement = true;

		};

		// True if a handler has been added using jQuery.

		var evs = $(opt).data("events");

		if (evs && evs[name]) {

			evt.hasEvent = true;

			evt.byJQuery = true;

		};

		return evt;

	};

	var fireOptionEventIfExist = function (li, evt_n) {

		if (settings.disabledOptionEvents == false) {

			var opt = getElement(element).options[getIndex(li)];

			//check if original has some

			if (option_has_handler(opt, evt_n).hasEvent === true) {

				if (option_has_handler(opt, evt_n).byElement === true) {

					opt["on" + evt_n]();

				};

				if (option_has_handler(opt, evt_n).byJQuery === true) {

					switch (evt_n) {

						case "keydown":

						case "keyup":

							//key down/up will check later

							break;

						default:

							$(opt).trigger(evt_n);

							break;

					};

				};

				return false;

			};

		};

	};

	var fireEventIfExist = function (evt_n) {

		//local

		if (typeof settings.on[evt_n] == "function") {

			settings.on[evt_n].apply(this, arguments);

		};

		//check if original has some

		if (has_handler(evt_n).hasEvent === true) {

			if (has_handler(evt_n).byElement === true) {

				getElement(element)["on" + evt_n]();

			} else if (has_handler(evt_n).byJQuery === true) {

				switch (evt_n) {

					case "keydown":

					case "keyup":

						//key down/up will check later

						break;

					default:

						$("#" + element).triggerHandler(evt_n);

						break;

				};

			};

			return false;

		};

	};

	/******************************* navigation **********************************************/

	var scrollToIfNeeded = function (opt) {

		var childid = getPostID("postChildID");

		//if scroll is needed

		opt = (opt !== undefined) ? opt : $("#" + childid + " li." + css.selected);

		if (opt.length > 0) {

			var pos = parseInt(($(opt).position().top));

			var ch = parseInt($("#" + childid).height());

			if (pos > ch) {

				var top = pos + $("#" + childid).scrollTop() - (ch/2);

				$("#" + childid).animate({scrollTop:top}, 500);

			};

		};

	};

	var next = function () {

		var childid = getPostID("postChildID");

		var items = $("#" + childid + " li:visible." + css_i.li);

		var selected = $("#" + childid + " li:visible." + css.selected);

		selected = (selected.length==0) ? items[0] : selected;

		var index = $("#" + childid + " li:visible." + css_i.li).index(selected);

		if ((index < items.length - 1)) {

			index = getNext(index);

			if (index < items.length) { //check again - hack for last disabled 

				if (!shiftHolded || !isList || !isMultiple) {

					$("#" + childid + " ." + css.selected).removeClass(css.selected);

				};

				$(items[index]).addClass(css.selected);

				updateTitleUI(index);

				if (isList == true) {

					fireAfterItemClicked();

				};

				scrollToIfNeeded($(items[index]));

			};

			if (!isList) {

				adjustOpen();

			};

		};	

		function getNext(ind) {

			ind = ind + 1;

			if (ind > items.length) {

				return ind;

			};

			if ($(items[ind]).hasClass(css.enabled) === true) {

				return ind;

			};

			return ind = getNext(ind);

		};

	};

	var previous = function () {

		var childid = getPostID("postChildID");

		var selected = $("#" + childid + " li:visible." + css.selected);

		var items = $("#" + childid + " li:visible." + css_i.li);

		var index = $("#" + childid + " li:visible." + css_i.li).index(selected[0]);

		if (index >= 0) {

			index = getPrev(index);

			if (index >= 0) { //check again - hack for disabled 

				if (!shiftHolded || !isList || !isMultiple) {

					$("#" + childid + " ." + css.selected).removeClass(css.selected);

				};

				$(items[index]).addClass(css.selected);

				updateTitleUI(index);

				if (isList == true) {

					fireAfterItemClicked();

				};

				if (parseInt(($(items[index]).position().top + $(items[index]).height())) <= 0) {

					var top = ($("#" + childid).scrollTop() - $("#" + childid).height()) - $(items[index]).height();

					$("#" + childid).animate({scrollTop: top}, 500);

				};

			};

			if (!isList) {

				adjustOpen();

			};

		};

	

		function getPrev(ind) {

			ind = ind - 1;

			if (ind < 0) {

				return ind;

			};

			if ($(items[ind]).hasClass(css.enabled) === true) {

				return ind;

			};

			return ind = getPrev(ind);

		};

	};

	var adjustOpen = function () {

		var id = getPostID("postID");

		var childid = getPostID("postChildID");

		var pos = $("#" + id).offset();

		var mH = $("#" + id).height();

		var wH = $(window).height();

		var st = $(window).scrollTop();

		var cH = $("#" + childid).height();

		var top = $("#" + id).height(); //this close so its title height

		var direction = settings.openDirection.toLowerCase();

		if (((wH + st) < Math.floor(cH + mH + pos.top) || direction == 'alwaysup') && direction != 'alwaysdown') {

			top = cH;

			$("#" + childid).css({top: "-" + top + "px", display: 'block', zIndex: settings.zIndex});			

			if(settings.roundedCorner == "true") {

				$("#" + id).removeClass("borderRadius borderRadiusTp").addClass("borderRadiusBtm");

			};

			var top = $("#" + childid).offset().top;

			if (top < -10) {

				$("#" + childid).css({top: (parseInt($("#" + childid).css("top")) - top + 20 + st) + "px", zIndex: settings.zIndex});

				if(settings.roundedCorner == "true") {

					$("#" + id).removeClass("borderRadiusBtm borderRadiusTp").addClass("borderRadius");

				};

			};

		} else {

			$("#" + childid).css({top: top + "px", zIndex: settings.zIndex});			

			if(settings.roundedCorner == "true") {

				$("#" + id).removeClass("borderRadius borderRadiusBtm").addClass("borderRadiusTp");

			};

		};

		//hack for ie zindex

		//i hate ie :D

		if(isIE) {

			if(msieversion()<=7) {

				$('div.ddcommon').css("zIndex", settings.zIndex-10);

				$("#" + id).css("zIndex", settings.zIndex+5);

			};

		};		

	};

	var open = function (e) {

		if (isDisabled === true) return false;

		var id = getPostID("postID");

		var childid = getPostID("postChildID");

		if (!isOpen) {

			isOpen = true;

			if (msBeautify.oldDiv != '') {

				$("#" + msBeautify.oldDiv).css({display: "none"}); //hide all 

			};

			msBeautify.oldDiv = childid;

			$("#" + childid + " li:hidden").show(); //show if hidden

			adjustOpen();

			var animStyle = settings.animStyle;

			if(animStyle=="" || animStyle=="none") {

				$("#" + childid).css({display:"block"});

				scrollToIfNeeded();

				if (typeof settings.on.open == "function") {

					var d = getDataAndUI();

					settings.on.open(d.data, d.ui);

				};

			} else {				

				$("#" + childid)[animStyle]("fast", function () {

					scrollToIfNeeded();

					if (typeof settings.on.open == "function") {

						var d = getDataAndUI();

						settings.on.open(d.data, d.ui);

					};

				});

			};

			bind_on_events();

		} else {

			if(settings.event!=='mouseover') {

				close();

			};

		};

	};

	var close = function (e) {

		isOpen = false;

		var id = getPostID("postID");

		var childid = getPostID("postChildID");

		if (isList === false || settings.enableCheckbox===true) {

			$("#" + childid).css({display: "none"});			

			if(settings.roundedCorner == "true") {

				$("#" + id).removeClass("borderRadiusTp borderRadiusBtm").addClass("borderRadius");

			};

		};

		unbind_on_events();

		if (typeof settings.on.close == "function") {

			var d = getDataAndUI();

			settings.on.close(d.data, d.ui);

		};

		//rest some old stuff

		hideFilterBox();

		childHeight(childHeight()); //its needed after filter applied

		$("#" + childid).css({zIndex:1});

		//update the title in case the user clicked outside

		updateTitleUI(getElement(element).selectedIndex);

	};

	/*********************** </layout> *************************************/	

	var mergeAllProp = function () {

		try {

			orginial = $.extend(true, {}, getElement(element));

			for (var i in orginial) {

				if (typeof orginial[i] != "function") {				

					$this[i] = orginial[i]; //properties

				};

			};

		} catch(e) {

			//silent

		};

		$this.selectedText = (getElement(element).selectedIndex >= 0) ? getElement(element).options[getElement(element).selectedIndex].text : "";		

		$this.version = msBeautify.version.msDropdown;

		$this.author = msBeautify.author;

	};

	var getDataAndUIByOption = function (opt) {

		if (opt != null && typeof opt != "undefined") {

			var childid = getPostID("postChildID");

			var data = parseOption(opt);

			var ui = $("#" + childid + " li." + css_i.li + ":eq(" + (opt.index) + ")");

			return {data: data, ui: ui, option: opt, index: opt.index};

		};

		return null;

	};

	var getDataAndUI = function () {

		var childid = getPostID("postChildID");

		var ele = getElement(element);

		var data, ui, option, index;

		if (ele.selectedIndex == -1) {

			data = null;

			ui = null;

			option = null;

			index = -1;

		} else {

			ui = $("#" + childid + " li." + css.selected);

			if (ui.length > 1) {

				var d = [], op = [], ind = [];

				for (var i = 0; i < ui.length; i++) {

					var pd = getIndex(ui[i]);

					d.push(pd);

					op.push(ele.options[pd]);

				};

				data = d;

				option = op;

				index = d;

			} else {

				option = ele.options[ele.selectedIndex];

				data = parseOption(option);

				index = ele.selectedIndex;

			};

		};

		return {data: data, ui: ui, index: index, option: option};

	};

	var updateTitleUI = function (index, byvalue) {

		var titleid = getPostID("postTitleID");

		var value = {};

		if (index == -1) {

			value.text = "&nbsp;";

			value.className = "";

			value.description = "";

			value.image = "";

		} else if (typeof index != "undefined") {

			var opt = getElement(element).options[index];

			value = parseOption(opt);

		} else {

			value = byvalue;

		};

		//update title and current

		$("#" + titleid).find("." + css.label).html(value.text);

		getElement(titleid).className = css.ddTitleText + " " + value.className;

		//update desction

		if (value.description != "") {

			$("#" + titleid).find("." + css.description).html(value.description).show();

		} else {

			$("#" + titleid).find("." + css.description).html("").hide();

		};

		//update icon

		var img = $("#" + titleid).find("img");

		if (img.length > 0) {

			$(img).remove();

		};

		if (value.image != "" && settings.showIcon) {

			img = createElement("img", {src: value.image});

			$("#" + titleid).prepend(img);

			if(value.imagecss!="") {

				img.className = value.imagecss+" ";

			};

			if (value.description == "") {

				img.className = img.className+css_i.fnone;

			};

		};

	};

	var updateProp = function (p, v) {

		$this[p] = v;

	};

	var updateUI = function (a, opt, i) { //action, index, opt

		var childid = getPostID("postChildID");

		var wasSelected = false;

		switch (a) {

			case "add":

				var li = createChild(opt || getElement(element).options[i]);				

				var index;

				if (arguments.length == 3) {

					index = i;

				} else {

					index = $("#" + childid + " li." + css_i.li).length - 1;

				};				

				if (index < 0 || !index) {

					$("#" + childid + " ul").append(li);

				} else {

					var at = $("#" + childid + " li." + css_i.li)[index];

					$(at).before(li);

				};

				removeChildEvents();

				applyChildEvents();

				if (settings.on.add != null) {

					settings.on.add.apply(this, arguments);

				};

				break;

			case "remove":

				wasSelected = $($("#" + childid + " li." + css_i.li)[i]).hasClass(css.selected);

				$("#" + childid + " li." + css_i.li + ":eq(" + i + ")").remove();

				var items = $("#" + childid + " li." + css.enabled);

				if (wasSelected == true) {

					if (items.length > 0) {

						$(items[0]).addClass(css.selected);

						var ind = $("#" + childid + " li." + css_i.li).index(items[0]);

						setValue(ind);

					};

				};

				if (items.length == 0) {

					setValue(-1);

				};

				if ($("#" + childid + " li." + css_i.li).length < settings.visibleRows && !isList) {

					childHeight(-1); //set autoheight

				};

				if (settings.on.remove != null) {

					settings.on.remove.apply(this, arguments);

				};

				break;

		};	

	};

	/************************** public methods/events **********************/

	this.act = function () {

		var action = arguments[0];

		Array.prototype.shift.call(arguments);

		switch (action) {

			case "add":

				$this.add.apply(this, arguments);

				break;

			case "remove":

				$this.remove.apply(this, arguments);

				break;

			default:

				try {

					getElement(element)[action].apply(getElement(element), arguments);

				} catch (e) {

					//there is some error.

				};

				break;

		};

	};

	

	this.add = function () {

		var text, value, title, image, description;

		var obj = arguments[0];		

		if (typeof obj == "string") {

			text = obj;

			value = text;

			opt = new Option(text, value);

		} else {

			text = obj.text || '';

			value = obj.value || text;

			title = obj.title || '';

			image = obj.image || '';

			description = obj.description || '';

			//image:imagePath, title:title, description:description, value:opt.value, text:opt.text, className:opt.className||""

			opt = new Option(text, value);

			$(opt).data("description", description);

			$(opt).data("image", image);

			$(opt).data("title", title);

		};

		arguments[0] = opt; //this option

		getElement(element).add.apply(getElement(element), arguments);

		updateProp("children", getElement(element)["children"]);

		updateProp("length", getElement(element).length);

		updateUI("add", opt, arguments[1]);

	};

	this.remove = function (i) {

		getElement(element).remove(i);

		updateProp("children", getElement(element)["children"]);

		updateProp("length", getElement(element).length);

		updateUI("remove", undefined, i);

	};

	this.set = function (prop, val) {

		if (typeof prop == "undefined" || typeof val == "undefined") return false;

		prop = prop.toString();

		try {

			updateProp(prop, val);

		} catch (e) {/*this is ready only */};

		switch (prop) {

			case "size":

				getElement(element)[prop] = val;

				if (val == 0) {

					getElement(element).multiple = false; //if size is zero multiple should be false

				};

				isList = (getElement(element).size > 1 || getElement(element).multiple == true) ? true : false;

				fixedForList();

				break;

			case "multiple":

				getElement(element)[prop] = val;

				isList = (getElement(element).size > 1 || getElement(element).multiple == true) ? true : false;

				isMultiple = getElement(element).multiple;

				fixedForList();

				updateProp(prop, val);

				break;

			case "disabled":

				getElement(element)[prop] = val;

				isDisabled = val;

				fixedForDisabled();

				break;

			case "selectedIndex":

			case "value":				

				if(prop=="selectedIndex" && isArray(val)===true) {

					$("#"+element +" option").prop("selected", false);

					selectMutipleOptions(val, true);

					selectUI_LI(val); //setValue is being called from selectMutipleOptions

				} else {

					getElement(element)[prop] = val;					

					selectUI_LI(getElement(element).selectedIndex);

					setValue(getElement(element).selectedIndex);

				};

				break;

			case "length":

				var childid = getPostID("postChildID");

				if (val < getElement(element).length) {

					getElement(element)[prop] = val;

					if (val == 0) {

						$("#" + childid + " li." + css_i.li).remove();

						setValue(-1);

					} else {

						$("#" + childid + " li." + css_i.li + ":gt(" + (val - 1) + ")").remove();

						if ($("#" + childid + " li." + css.selected).length == 0) {

							$("#" + childid + " li." + css.enabled + ":eq(0)").addClass(css.selected);

						};

					};

					updateProp(prop, val);

					updateProp("children", getElement(element)["children"]);

				};

				break;

			case "id":

				//please i need this. so preventing to change it. will work on this later

				break;

			default:

				//check if this is not a readonly properties

				try {

					getElement(element)[prop] = val;

					updateProp(prop, val);

				} catch (e) {

					//silent

				};

				break;

		};

	};

	this.get = function (prop) {

		return $this[prop] || getElement(element)[prop]; //return if local else from original

	};

	this.visible = function (val) {

		var id = getPostID("postID");		

		if (val === true) {

			$("#" + id).show();

		} else if (val === false) {

			$("#" + id).hide();

		} else {

			return ($("#" + id).css("display")=="none") ? false : true;

		};

	};

	this.debug = function (v) {

		msBeautify.debug(v);

	};

	this.close = function () {

		close();

	};

	this.open = function () {		

		open();

	};

	this.showRows = function (r) {

		if (typeof r == "undefined" || r == 0) {

			return false;

		};

		settings.visibleRows = r;

		childHeight(childHeight());

	};

	this.visibleRows = this.showRows;

	this.on = function (type, fn) {

		$("#" + element).on(type, fn);

	};

	this.off = function (type, fn) {

		$("#" + element).off(type, fn);

	};

	this.addMyEvent = this.on;

	this.getData = function () {

		return getDataAndUI()

	};

	this.namedItem = function () {

		var opt = getElement(element).namedItem.apply(getElement(element), arguments);

		return getDataAndUIByOption(opt);

	};

	this.item = function () {

		var opt = getElement(element).item.apply(getElement(element), arguments);

		return getDataAndUIByOption(opt);

	};	

	//v 3.2

	this.setIndexByValue = function(val) {

		this.set("value", val);

	};

	this.destroy = function () {

		var hidid = getPostID("postElementHolder");

		var id = getPostID("postID");

		$("#" + id + ", #" + id + " *").off();

		getElement(element).tabIndex = getElement(id).tabIndex;

		$("#" + id).remove();

		$("#" + element).parent().replaceWith($("#" + element));		

		$("#" + element).data("dd", null);

	};

	this.refresh = function() {

		setValue(getElement(element).selectedIndex);

	};

	//Create msDropDown	

	init();

};

//bind in jquery

$.fn.extend({

			msDropDown: function(settings)

			{

				return this.each(function()

				{

					if (!$(this).data('dd')){

						var mydropdown = new dd(this, settings);

						$(this).data('dd', mydropdown);

					};

				});

			}

});

$.fn.msDropdown = $.fn.msDropDown; //make a copy

})(jQuery);