<?php
add_shortcode( 'latest_verse_talks', 'latest_verse_talks' );

function latest_verse_talks() {
	$args = array(
		'cat'				=> 19,
		'numberposts'		 => 1,
		'offset'		 => 0,
		'orderby'		 => 'post_date',
		'order'			 => 'DESC',
		'post_type'		 => 'post',
		'post_status'		 => 'publish',
		'suppress_filters'	 => false
	);
	$html = '<div class="latest-verse-talks fit-p clearfix">'
			. '<h3 class="latest-verse-talks-title entry-title h2"><a href="%1$s">%2$s</a></h3>'
			. '<p class="latest-verse-talks-date">%3$s</p>'
			. '<div class="latest-verse-talks-content">%4$s</div>'
			. '</div>';
	$recent_posts	 = wp_get_recent_posts( $args );

	$results = '';

	foreach ( $recent_posts as $recent ) {
		$post_id = absint( $recent["ID"] );
		$results .= sprintf( $html, esc_url( get_permalink( $post_id ) ), wp_kses_post( $recent["post_title"] ), get_the_date(), wp_kses_post( apply_filters( 'the_content', $recent["post_content"] ) )
		);
	}
	wp_reset_query();
	return $results;
}
